/* -*-C-*-
 ##############################################################################
 #
 # File:        trice/inc/E1430.h
 # RCS:         "@(#)$Revision: 1.19 $ $Date: 94/03/16 14:25:51 $"
 # Description: header file for E1430 module library
 # Author:      Doug Passey
 # Created:     
 # Language:    C 
 # Package:     E1430
 # Status:      "@(#)$State: Exp $"
 #
 # (C) Copyright 1992, Hewlett-Packard Company, all rights reserved.
 #
 ##############################################################################
 #
 # This  is the header  file  included with  the Measurement  Interface
 # Library  (MIL)  for the E1430 VXI module.  Any  host program that
 # makes use of the E1430 module should include this file.
 #
 # Revisions:
 #
 ##############################################################################
*/

#ifndef _E1430_INCLUDED
#define _E1430_INCLUDED

#include "machType.h"

/* defines to implement TRY - RECOVER mechanism to VXI/VME bus errors */
#ifdef RADISYS
  /* On the RadiSys EPC-7, a bus error does not suspend the program.  */
  /* It is detected by checking a hardware register after the memory  */
  /* read or write.  */
#  define E1430_TRY	if(setjmp(e1430_env) == 0) { e1430_clear_berr(); 
#  define E1430_CHECK_BERR if(e1430_check_berr()) longjmp(e1430_env,1); 
#  define E1430_RECOVER	  }else
#else
#  define E1430_TRY		if(setjmp(e1430_env) == 0) {
#  define E1430_CHECK_BERR 
#  define E1430_RECOVER		}else
#endif

/* defines for address offsets of registers from module base address */
#define E1430_VXI_ID_REG			0x00
#define E1430_VXI_DEVICE_TYPE_REG		0x02
#define E1430_VXI_STATUS_REG			0x04
#define E1430_VXI_CONTROL_REG			0x04
#define E1430_ANALOG_SETUP_REG			0x06
#define E1430_INPUT_OFFSET_REG			0x08
#define E1430_MEAS_CONTROL_REG			0x0A
#define E1430_DATA_FORMAT_REG			0x0C
#define E1430_IRQ_CONFIG_0_REG			0x14
#define E1430_IRQ_CONFIG_1_REG			0x16
#define E1430_HP_PORT_CONTROL_REG		0x18	
#define E1430_HP_COMMON_REG	          	0x1A
#define E1430_TRIGGER_SETUP_REG			0x1A
#define E1430_HP_DESCRIPTION_REG		0x1C
#define E1430_TRIGGER_BLOCKSIZE_REG		0x1C
#define E1430_HP_SUBCLASS_REG			0x1E
#define E1430_TRIGGER_OFFSET_LO_REG		0x1E
#define E1430_HP_SEND_DATA_REG			0x22
#define E1430_TIMING_SETUP_REG			0x24
#define E1430_ADC_CONTROL_REG			0x26
#define E1430_TRIGGER_PASSOUT_REG		0x28
#define E1430_DECIMATION_CNTLAT_0_REG		0x28
#define E1430_DECIMATION_RESET_REG		0x2A
#define E1430_DECIMATION_CNTLAT_1_REG		0x2A
#define E1430_DECIMATION_CAPTURE_REG		0x2C
#define E1430_DECIMATION_CNTLAT_2_REG		0x2C
#define E1430_DECIMATION_CNTLAT_3_REG		0x2E
#define E1430_ZOOM_PHASE_1_REG			0x30
#define E1430_ZOOM_PHASE_0_REG			0x32
#define E1430_ZOOM_INTERP_3_REG			0x34
#define E1430_ZOOM_INTERP_2_REG			0x36
#define E1430_ZOOM_INTERP_1_REG			0x38
#define E1430_ZOOM_INTERP_0_REG			0x3A
#define E1430_ZOOM_CONTROL_REG			0x3C
#define E1430_LO_TRANSFER_REG			0x3E

/* defines for display_register */
#define E1430_IMAGE_REGISTER		0
#define E1430_CARD_REGISTER		1

/* defines for analog input */
#define E1430_COUPLING_AC 		100
#define E1430_COUPLING_DC 		101

#define E1430_ANTIALIAS_ON		110
#define E1430_ANTIALIAS_OFF		111

#define E1430_INPUT_HI_CONN		120
#define E1430_INPUT_HI_GROUND		121
#define E1430_INPUT_LO_FLOAT		122
#define E1430_INPUT_LO_GROUND		123

/* defines for timing setup parameters */
#define E1430_ADC_CLOCK_INTERNAL	200
#define E1430_ADC_CLOCK_EXTERNAL	201

#define E1430_DSP_CLOCK_INTERNAL	210
#define E1430_DSP_CLOCK_ADC		211

#define E1430_MULTI_SYNC_ON		220
#define E1430_MULTI_SYNC_OFF		221

#define E1430_MASTER_CLOCK_ON		240
#define E1430_MASTER_CLOCK_OFF		241

/* defines for data I/O parameters */
#define E1430_SEND_PORT_VME		300
#define E1430_SEND_PORT_LBUS		301

#define E1430_APPEND_STATUS_OFF		310
#define E1430_APPEND_STATUS_ON		311

#define E1430_DATA_TYPE_REAL		320
#define E1430_DATA_TYPE_COMPLEX		321

#define E1430_DATA_SIZE_16		330
#define E1430_DATA_SIZE_32		331

#define E1430_BLOCK_MODE 		340
#define E1430_CONTINUOUS_MODE		341

#define E1430_LBUS_GENERATE		351
#define E1430_LBUS_APPEND		352
#define E1430_LBUS_INSERT		353
#define E1430_LBUS_PIPELINE		354

/* defines for reset states for LBUS */
#define E1430_RESET_LBUS_ON		360
#define E1430_RESET_LBUS_OFF		361

/* Defines for triggering parameters */
#define E1430_TRIGGER_SOURCE_AUTO	400
#define E1430_TRIGGER_SOURCE_EXT	401
#define E1430_TRIGGER_SOURCE_ADC	402
#define E1430_TRIGGER_SOURCE_MAG	403
#define E1430_TRIGGER_SOURCE_OFF	404

#define E1430_TRIGGER_SLOPE_POS	410
#define E1430_TRIGGER_SLOPE_NEG	411

/* defines for decimation filter parameters */
#define E1430_DECIMATION_ON		600
#define E1430_DECIMATION_OFF		601

#define E1430_PASS_TAG_24		610
#define E1430_PASS_TAG_32		611

#define E1430_ONEPASS			620
#define E1430_MULTIPASS			621

/* defines for zoom parameters */
#define E1430_ZOOM_ON			700
#define E1430_ZOOM_OFF			701

/* defines for data reread parameters */
#define E1430_DATA_REREAD_ON		800
#define E1430_DATA_REREAD_OFF		801


/* Defines for bit positions in the measurement status register */
#define E1430_MEAS_STATUS_STATE_MASK		3
#define E1430_MEAS_STATUS_IDLE_STATE		0
#define E1430_MEAS_STATUS_ARM_STATE		1
#define E1430_MEAS_STATUS_MEAS_STATE		2
#define E1430_MEAS_STATUS_TRIG_STATE		3

#define E1430_MEAS_STATUS_MEM_MASK		0x0030
#define E1430_MEAS_STATUS_CLOCK_MASK		0x0040
#define E1430_MEAS_STATUS_SYNC_VALID		0x0080
#define E1430_MEAS_STATUS_READ_VALID		0x0100
#define E1430_MEAS_STATUS_BLOCK_READY		0x0200
#define E1430_MEAS_STATUS_ARMED			0x0400
#define E1430_MEAS_STATUS_MEAS_DONE		0x0800
#define E1430_MEAS_STATUS_OVERLOAD		0x1000
#define E1430_MEAS_STATUS_ADC_ERROR		0x2000
#define E1430_MEAS_STATUS_MODID	       		0x4000

/* defines for fifo memory size */
#define E1430_MEM_SIZE_8		0x00
#define E1430_MEM_SIZE_16		0x10
#define E1430_MEM_SIZE_32		0x20
#define E1430_MEM_SIZE_64		0x30

/* defines for clock frequency */
#define E1430_CLOCK_FREQ_1000		0x00
#define E1430_CLOCK_FREQ_1024		0x40


/* defines for bit positions in interrupt mask */
#define E1430_INTR_READ_VALID		0x0100
#define E1430_INTR_BLOCK_READY		0x0200
#define E1430_INTR_MODULE_ARMED		0x0400
#define E1430_INTR_MEAS_DONE		0x0800
#define E1430_INTR_INPUT_OVERLOAD	0x1000
#define E1430_INTR_ADC_ERROR		0x2000

/* defines for checkla parameter in restore_state_file() */
#define E1430_CHECK_LA_MISMATCH		200
#define E1430_IGNORE_LA_MISMATCH	201

/* defines for flag parameter for e1430_diagnostics routine */
#define MEM_TEST_FLAG			1
#define REG_ACCESS_TEST_FLAG		2

/* Definition of the Module State Structure ... the basic data structure
 * containing all the current settings of the module excluding the status
 * registers */

typedef struct {
  SHORTSIZ16		logicalAddr;		/* logical address */

  /********************** ANALOG SECTION *******************************/
  FLOATSIZ64		range;			/* range setting in volts */
  SHORTSIZ16		coupling;		/* COUPLING_AC, _DC */
  SHORTSIZ16		inputHigh;		/* INPUT_HI_CONN, _GROUND */
  SHORTSIZ16		inputLow;		/* INPUT_LO_FLOAT, _GROUND */
  SHORTSIZ16		inputFilter;		/* ANTI_ALIAS_ON, OFF */
  
  /********************** DATA FORMAT *******************************/
  LONGSIZ32		blocksize;		/*blocksize of data in samples*/
  SHORTSIZ16		dataMode;		/* BLOCK_MODE,CONTINUOUS_MODE */
  SHORTSIZ16		appendStatus;		/* APPEND_STATUS_ON, _OFF*/
  SHORTSIZ16		dataType;	   	/* DATA_REAL, _COMPLEX */
  SHORTSIZ16		dataSize;		/* DATA_SIZE_16, _32 */
  SHORTSIZ16		dataPort; 		/* SEND_PORT_VME, _LBUS */
 
  /************************** TIMING *******************************/
  SHORTSIZ16		masterState;		/* MASTER_CLOCK_ON, _OFF */
  SHORTSIZ16		syncState;		/*MULTI_SYNC_ON, _OFF */
  SHORTSIZ16		adcClock;		/* ADC_CLOCK_INTERNAL, 
						   _EXTERNAL */
  SHORTSIZ16		dspClock;		/*DSP_CLOCK_INTERNAL,
						  DSP_CLOCK_ADC*/

  /************************** TRIGGER *******************************/
  SHORTSIZ16		triggerMode;		/*TRIGGER_SOURCE_OFF, _EXT,
						  _ADC, _MAG */
  SHORTSIZ16		triggerSlope; 		/*TRIGGER_POSITIVE, _NEGATIVE*/
  FLOATSIZ64		triggerLevelADC;	/* trigger level as fraction */
						/* of full scale */
  FLOATSIZ64		triggerLevelMag;	/* trigger level as dBs from */
						/* full scale */
  LONGSIZ32		triggerDelay;		/*trigger delay in samples*/
  SHORTSIZ16		triggerBw;		/*trigger BW for MAG trigger,
						  Fs/2^N+1, N=0 off, N < 25 */

  /************************** MEASUREMENT *******************************/
  SHORTSIZ16		armMode;		/* MANUAL_ARM, AUTO_ARM */
  SHORTSIZ16		intrPriority0;		/* priority of intr #0 (0-7) */
  SHORTSIZ16		intrMask0;		/* mask of interrupt #0 */
  SHORTSIZ16		intrPriority1;		/* priority of intr #1 (0-7) */
  SHORTSIZ16		intrMask1;		/* mask of interrupt #1 */

  /************************** DECIMATION *******************************/
  SHORTSIZ16		decimationBw;		/* N=0 OFF, Fs/2^N N=1-24 */
  SHORTSIZ16		decimationState;	/* DECIMATION_ON, _OFF */
  SHORTSIZ16		decimationOutput;	/* ONEPASS, MULTIPASS */
  SHORTSIZ16		passTag;		/* PASS_TAG_24, _32 */
  
  /************************** ZOOM *******************************/
  FLOATSIZ64		centerFreq;		/* center frequency */
  SHORTSIZ16		zoomFilter;		/* ZOOM_FILTER_ON, _OFF */
  /************************** MEMORY *******************************/
  LONGSIZ32		memorySize;		/* memory in bytes in FIFO */
}aE1430State;


/****************** ERRORS *********************/
extern char *e1430_get_error_string(void);
extern SHORTSIZ16 e1430_print_errors(SHORTSIZ16 state);

/****************** INITIALIZATION *********************/
extern SHORTSIZ16 e1430_init_io_driver(void);
extern SHORTSIZ16 e1430_create_module_group(SHORTSIZ16 numMods, 
					SHORTSIZ16 DOS_FAR *laArray);
extern SHORTSIZ16 e1430_delete_module_group(SHORTSIZ16 groupID);
extern SHORTSIZ16 e1430_delete_all_module_groups(void);
extern SHORTSIZ16 e1430_reset_module(SHORTSIZ16 groupID);
extern SHORTSIZ16 e1430_reset_dsp(SHORTSIZ16 groupID);
extern SHORTSIZ16 e1430_reset_lbus(SHORTSIZ16 groupID, SHORTSIZ16 state);
extern SHORTSIZ16 e1430_set_timeout(LONGSIZ32 timeout); 
extern SHORTSIZ16 e1430_get_timeout(LONGSIZ32 *timeout); 

/****************** TIMING *********************/
extern SHORTSIZ16 e1430_set_clock_mode(SHORTSIZ16 groupID, 
	SHORTSIZ16 multiSync, SHORTSIZ16 adcClock, SHORTSIZ16 dspClock);

extern SHORTSIZ16 e1430_set_clock_master_mode(SHORTSIZ16 la, SHORTSIZ16 state);
extern SHORTSIZ16 e1430_get_clock_master_mode(SHORTSIZ16 la, SHORTSIZ16 *state);

extern SHORTSIZ16 e1430_set_adc_clock(SHORTSIZ16 groupID, SHORTSIZ16 adcClock);
extern SHORTSIZ16 e1430_get_adc_clock(SHORTSIZ16 groupID, SHORTSIZ16 *sourcePtr);
    
extern SHORTSIZ16 e1430_set_dsp_clock(SHORTSIZ16 groupID, SHORTSIZ16 dspClock);
extern SHORTSIZ16 e1430_get_dsp_clock(SHORTSIZ16 groupID, SHORTSIZ16 *sourcePtr);
    
extern SHORTSIZ16 e1430_set_multi_sync(SHORTSIZ16 groupID, SHORTSIZ16 state);
extern SHORTSIZ16 e1430_get_multi_sync(SHORTSIZ16 groupID, SHORTSIZ16 *statePtr);

extern SHORTSIZ16 e1430_set_sample_clock_freq_la(SHORTSIZ16 la, 
							FLOATSIZ64 freq);
extern SHORTSIZ16 e1430_get_sample_clock_freq_la(SHORTSIZ16 la, 
							FLOATSIZ64 *freqPtr);

/****************** ANALOG *********************/
extern SHORTSIZ16 e1430_auto_zero(SHORTSIZ16 groupID);
extern SHORTSIZ16 e1430_auto_range(SHORTSIZ16 groupID, FLOATSIZ64 delay);

extern SHORTSIZ16 e1430_set_analog_input(SHORTSIZ16 groupID, FLOATSIZ64 range, 
    SHORTSIZ16 coupling, SHORTSIZ16 filter, SHORTSIZ16 inHi, SHORTSIZ16 inLo);

extern SHORTSIZ16 e1430_set_range(SHORTSIZ16 groupID, FLOATSIZ64 range);
extern SHORTSIZ16 e1430_get_range(SHORTSIZ16 groupID, FLOATSIZ64 *rangePtr);

extern SHORTSIZ16 e1430_set_range_la(SHORTSIZ16 la, FLOATSIZ64 range);
extern SHORTSIZ16 e1430_get_range_la(SHORTSIZ16 la, FLOATSIZ64 *rangePtr);

extern SHORTSIZ16 e1430_set_anti_alias_filter(SHORTSIZ16 groupID, 
							SHORTSIZ16 state);
extern SHORTSIZ16 e1430_get_anti_alias_filter(SHORTSIZ16 groupID, 
							SHORTSIZ16 *statePtr);

extern SHORTSIZ16 e1430_set_coupling(SHORTSIZ16 groupID, SHORTSIZ16 coupling);
extern SHORTSIZ16 e1430_get_coupling(SHORTSIZ16 groupID, 
						SHORTSIZ16 *couplingPtr);

extern SHORTSIZ16 e1430_set_input_high(SHORTSIZ16 groupID, SHORTSIZ16 source);
extern SHORTSIZ16 e1430_get_input_high(SHORTSIZ16 groupID, 
							SHORTSIZ16 *sourcePtr);

extern SHORTSIZ16 e1430_set_input_low(SHORTSIZ16 groupID, SHORTSIZ16 source);
extern SHORTSIZ16 e1430_get_input_low(SHORTSIZ16 groupID, 
							SHORTSIZ16 *sourcePtr);

extern SHORTSIZ16 e1430_set_input_offset(SHORTSIZ16 la, FLOATSIZ64 offset);
extern SHORTSIZ16 e1430_get_input_offset(SHORTSIZ16 la, FLOATSIZ64 *offsetPtr);

/****************** DATA FORMAT *********************/
extern SHORTSIZ16 e1430_set_data_format(SHORTSIZ16 groupID, SHORTSIZ16 type, 
			SHORTSIZ16 size, SHORTSIZ16 mode, 
			LONGSIZ32 blocksize, SHORTSIZ16 append);

extern SHORTSIZ16 e1430_set_data_port(SHORTSIZ16 groupID, SHORTSIZ16 port);
extern SHORTSIZ16 e1430_get_data_port(SHORTSIZ16 groupID, SHORTSIZ16 *portPtr);

extern SHORTSIZ16 e1430_set_data_mode(SHORTSIZ16 groupID, SHORTSIZ16 mode);
extern SHORTSIZ16 e1430_get_data_mode(SHORTSIZ16 groupID, SHORTSIZ16 *modePtr);

extern SHORTSIZ16 e1430_set_lbus_mode(SHORTSIZ16 la, SHORTSIZ16 mode);
extern SHORTSIZ16 e1430_get_lbus_mode(SHORTSIZ16 la, SHORTSIZ16 *modePtr);

extern SHORTSIZ16 e1430_set_append_status(SHORTSIZ16 groupID, 
							SHORTSIZ16 append);
extern SHORTSIZ16 e1430_get_append_status(SHORTSIZ16 groupID, 
							SHORTSIZ16 *appendPtr);

extern SHORTSIZ16 e1430_set_data_type(SHORTSIZ16 groupID, SHORTSIZ16 type);
extern SHORTSIZ16 e1430_get_data_type(SHORTSIZ16 groupID, SHORTSIZ16 *typePtr);

extern SHORTSIZ16 e1430_set_data_size(SHORTSIZ16 groupID, SHORTSIZ16 size);
extern SHORTSIZ16 e1430_get_data_size(SHORTSIZ16 groupID, SHORTSIZ16 *sizePtr);

extern SHORTSIZ16 e1430_set_blocksize(SHORTSIZ16 groupID, LONGSIZ32 size);
extern SHORTSIZ16 e1430_get_blocksize(SHORTSIZ16 groupID, LONGSIZ32 *sizePtr);

extern SHORTSIZ16 e1430_set_data_reread(SHORTSIZ16 groupID, SHORTSIZ16 reread);
extern SHORTSIZ16 e1430_get_data_reread(SHORTSIZ16 groupID, 
							SHORTSIZ16 *rereadPtr);

/****************** TRIGGER *********************/
extern SHORTSIZ16 e1430_set_trigger_mode(SHORTSIZ16 groupID, SHORTSIZ16 source, 
		LONGSIZ32 delay, FLOATSIZ64 level, SHORTSIZ16 slope);
extern SHORTSIZ16 e1430_get_trigger_phase(SHORTSIZ16 la, FLOATSIZ64 *phasePtr);

extern SHORTSIZ16 e1430_set_trigger_source(SHORTSIZ16 groupID, 
							SHORTSIZ16 source);
extern SHORTSIZ16 e1430_get_trigger_source(SHORTSIZ16 groupID, 
							SHORTSIZ16 *sourcePtr);

extern SHORTSIZ16 e1430_set_trigger_slope(SHORTSIZ16 groupID, SHORTSIZ16 slope);
extern SHORTSIZ16 e1430_get_trigger_slope(SHORTSIZ16 groupID, 
							SHORTSIZ16 *slopePtr);

extern SHORTSIZ16 e1430_set_trigger_level_adc(SHORTSIZ16 groupID, 
							FLOATSIZ64 level);
extern SHORTSIZ16 e1430_set_trigger_level_mag(SHORTSIZ16 groupID, 
							FLOATSIZ64 level);
extern SHORTSIZ16 e1430_get_trigger_level_adc(SHORTSIZ16 groupID, 
							FLOATSIZ64 *levelPtr);
extern SHORTSIZ16 e1430_get_trigger_level_mag(SHORTSIZ16 groupID, 
							FLOATSIZ64 *levelPtr);

extern SHORTSIZ16 e1430_set_trigger_delay(SHORTSIZ16 groupID, LONGSIZ32 delay);
extern SHORTSIZ16 e1430_get_trigger_delay(SHORTSIZ16 groupID, 
							LONGSIZ32 *delayPtr);

extern SHORTSIZ16 e1430_get_trigger_bandwidth(SHORTSIZ16 groupID, 
							SHORTSIZ16 *bwPtr);

/****************** MEASUREMENT *********************/

extern SHORTSIZ16 e1430_abort_meas(SHORTSIZ16 groupID);
extern SHORTSIZ16 e1430_arm_module(SHORTSIZ16 groupID);
extern SHORTSIZ16 e1430_trigger_module(SHORTSIZ16 groupID); 

extern SHORTSIZ16 e1430_set_center_frequency(SHORTSIZ16 groupID, 
							FLOATSIZ64 freq);
extern SHORTSIZ16 e1430_set_center_freq_bits(SHORTSIZ16 groupID, 
							FLOATSIZ64 freq);
extern SHORTSIZ16 e1430_get_center_frequency(SHORTSIZ16 groupID, 
							FLOATSIZ64 *freqPtr);

extern SHORTSIZ16 e1430_set_span_zoom(SHORTSIZ16 groupID, 
	FLOATSIZ64 centerFreq, FLOATSIZ64 span, SHORTSIZ16 zoom);
extern SHORTSIZ16 e1430_get_span(SHORTSIZ16 groupID, FLOATSIZ64 *spanPtr);

extern SHORTSIZ16 e1430_get_status(SHORTSIZ16 la, SHORTSIZ16 *statusPtr);

/****************** INTERRUPTS *********************/
extern SHORTSIZ16 e1430_set_interrupt(SHORTSIZ16 groupID, SHORTSIZ16 intrNum, 
				SHORTSIZ16 priority, SHORTSIZ16 mask);
extern SHORTSIZ16 e1430_set_interrupt_priority(SHORTSIZ16 groupID, 
				SHORTSIZ16 intrNum, SHORTSIZ16 priority);
extern SHORTSIZ16 e1430_get_interrupt_priority(SHORTSIZ16 groupID, 
				SHORTSIZ16 intrNum, SHORTSIZ16 *priorityPtr);
extern SHORTSIZ16 e1430_set_interrupt_mask(SHORTSIZ16 groupID, 
				SHORTSIZ16 intrNum, SHORTSIZ16 mask);
extern SHORTSIZ16 e1430_get_interrupt_mask(SHORTSIZ16 groupID, 
				SHORTSIZ16 intrNum, SHORTSIZ16 *maskPtr);

/****************** DECIMATION FILTER *********************/
extern SHORTSIZ16 e1430_set_decimation_filter(SHORTSIZ16 groupID, 
	SHORTSIZ16 level, SHORTSIZ16 state, SHORTSIZ16 output, SHORTSIZ16 tag);

extern SHORTSIZ16 e1430_set_decimation_bandwidth(SHORTSIZ16 groupID, 
				SHORTSIZ16 dataBw, SHORTSIZ16 triggerBw);
extern SHORTSIZ16 e1430_get_decimation_bandwidth(SHORTSIZ16 groupID, 
							SHORTSIZ16 *bwPtr);

extern SHORTSIZ16 e1430_set_decimation_state(SHORTSIZ16 groupID, 
							SHORTSIZ16 state);
extern SHORTSIZ16 e1430_get_decimation_state(SHORTSIZ16 groupID,
							SHORTSIZ16 *statePtr);

extern SHORTSIZ16 e1430_set_decimation_output(SHORTSIZ16 groupID, 
							SHORTSIZ16 out);
extern SHORTSIZ16 e1430_get_decimation_output(SHORTSIZ16 groupID, 
							SHORTSIZ16 *outPtr);

extern SHORTSIZ16 e1430_set_decimation_passtag(SHORTSIZ16 groupID, 
							SHORTSIZ16 tag);
extern SHORTSIZ16 e1430_get_decimation_passtag(SHORTSIZ16 groupID, 
							SHORTSIZ16 *tagPtr);

/****************** STATE FILE *********************/
extern SHORTSIZ16 e1430_save_state_file(SHORTSIZ16 groupID, 
							char DOS_FAR *filename);
extern SHORTSIZ16 e1430_restore_state_file(SHORTSIZ16 groupID, 
				char DOS_FAR *filename, SHORTSIZ16 checkla);


/****************** LOW LEVEL *********************/
extern SHORTSIZ16 *e1430_get_register_address(SHORTSIZ16 la, SHORTSIZ16 offset);
extern void e1430_set_try_recover(LONGSIZ32 state); 
extern SHORTSIZ16 e1430_clear_berr( void );
extern SHORTSIZ16 e1430_check_berr( void );

extern SHORTSIZ16 e1430_write_register(SHORTSIZ16 groupID, SHORTSIZ16 offset, 
							SHORTSIZ16 data);
extern SHORTSIZ16 e1430_write_register_image(SHORTSIZ16 la, SHORTSIZ16 offset, 
							SHORTSIZ16 data);
extern SHORTSIZ16 e1430_write_register_card(SHORTSIZ16 la, SHORTSIZ16 offset, 
							SHORTSIZ16 data);
extern SHORTSIZ16 e1430_read_register_card(SHORTSIZ16 la, SHORTSIZ16 offset, 
							SHORTSIZ16 *data);
extern SHORTSIZ16 e1430_read_register_image(SHORTSIZ16 la, SHORTSIZ16 offset, 
							SHORTSIZ16 *data);

/****************** READ DATA *********************/
extern SHORTSIZ16 e1430_read_raw_data(SHORTSIZ16 la, SHORTSIZ16 *buf, 
		LONGSIZ32 blocksize, SHORTSIZ16 *adcOverload, 
		SHORTSIZ16 *adcError, LONGSIZ32 *actualCnt);
extern SHORTSIZ16 e1430_read_float32_data(SHORTSIZ16 la, FLOATSIZ32 *buf, 
		LONGSIZ32 blocksize, SHORTSIZ16 *adcOverload, 
		SHORTSIZ16 *adcError, LONGSIZ32 *actualCnt);
extern SHORTSIZ16 e1430_read_float64_data(SHORTSIZ16 la, FLOATSIZ64 *buf, 
		LONGSIZ32 blocksize, SHORTSIZ16 *adcOverload, 
		SHORTSIZ16 *adcError, LONGSIZ32 *actualCnt);
extern SHORTSIZ16 e1430_get_fifo_block_data_size(SHORTSIZ16 la, 
							LONGSIZ32 *size);
extern SHORTSIZ16 e1430_get_scale_la(SHORTSIZ16 la, FLOATSIZ64 *scalePtr);

extern SHORTSIZ16 e1430_total_data_size(SHORTSIZ16 groupID, LONGSIZ32 *size);
extern SHORTSIZ16 e1430_get_fifo_size(SHORTSIZ16 la, LONGSIZ32 *size);
extern SHORTSIZ16 e1430_get_fifo_max_blocksize(SHORTSIZ16 groupID, 
							LONGSIZ32 *size);
extern SHORTSIZ16 e1430_get_fifo_data_point_size(SHORTSIZ16 la, 
							SHORTSIZ16 *size);


/****************** DEBUG *********************/
extern void e1430_debug_level(SHORTSIZ16 level);
extern SHORTSIZ16 e1430_display_module_state(SHORTSIZ16 groupID);
extern SHORTSIZ16 e1430_display_register(SHORTSIZ16 groupID, 
					SHORTSIZ16 offset, SHORTSIZ16 card);
extern SHORTSIZ16 e1430_get_module_state(SHORTSIZ16 la, 
						aE1430State DOS_FAR *state);
extern SHORTSIZ16 e1430_get_dac_error(SHORTSIZ16 la, FLOATSIZ64 *dac1, 
			FLOATSIZ64 *dac2, FLOATSIZ64 *dac3, FLOATSIZ64 *gain);

/****************** DIAGNOSTICS *********************/
extern SHORTSIZ16 e1430_diagnostics(SHORTSIZ16 la, SHORTSIZ16 memTestFlag);
extern SHORTSIZ16 e1430_test_logical_address(SHORTSIZ16 la);
extern SHORTSIZ16 e1430_test_register_access(SHORTSIZ16 la);
extern SHORTSIZ16 e1430_test_meas_control(SHORTSIZ16 la);
extern SHORTSIZ16 e1430_test_timing_setup(SHORTSIZ16 la);
extern SHORTSIZ16 e1430_test_fifo_memory(SHORTSIZ16 la);
extern SHORTSIZ16 e1430_test_data_collection(SHORTSIZ16 la);
extern SHORTSIZ16 e1430_test_interrupts(SHORTSIZ16 la);
extern SHORTSIZ16 e1430_test_trigger(SHORTSIZ16 la);
extern SHORTSIZ16 e1430_calibrate(SHORTSIZ16 la);
extern const char *e1430_get_software_rev(void);


/****************** RESAMPLING *********************/

extern SHORTSIZ16 e1430_get_filter_data(FLOATSIZ32 *data,FLOATSIZ32 *filt_data,
                                        FLOATSIZ32 *FIR_reg,SHORTSIZ16 clock,
                                        LONGSIZ32 size,SHORTSIZ16 filter,
                                        SHORTSIZ16 bw_num);

extern SHORTSIZ16 e1430_get_resample_data(FLOATSIZ32 *x,FLOATSIZ32 *resamp_data,
                                        FLOATSIZ32 *rec,SHORTSIZ16 clock,
                                        LONGSIZ32 num,SHORTSIZ16 filter,
                                        SHORTSIZ16 bw_num,FLOATSIZ32 dt,
                                        FLOATSIZ32 *re, FLOATSIZ32 *time,
                                        LONGSIZ32 *out_size);



#endif /* _E1430_INCLUDED */

